<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Resps\Interfaces\Administrator;
use Illuminate\Support\Facades\Auth;

class AdministratorController extends Controller
{
    protected $administrator;

    public function __construct(Administrator $administrator)
    {
        $this->administrator = $administrator;
    }

    public function login()
    {
        $username = trim(request()->get('username'));
        $password = trim(request()->get('password'));
        if (!$username || !$password) {
            return redirect('/login');
        }
        $validate = $this->administrator->login(['username' => $username, 'password' => $password]);
        if ($validate['code'] || !Auth::check()) {
            return redirect('/login');
        }
        return redirect('/admin');
    }

    public function logout()
    {
        return redirect($this->administrator->logout() ? '/login' : '/admin');
    }
}
