<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Response;
use App\Resps\Interfaces\Product as ProductInterface;

class ProductController extends Controller
{
    protected $product;

    public function __construct(ProductInterface $product)
    {
        $this->product = $product;
    }

    public function index()
    {
        $fillables = [
            'page',
            'name',
            'price',
            'order_by',
            'order',
            'keyword',
            'sort_id',
            'is_ajax'
        ];
        $params = request()->only($fillables);
        return $params['is_ajax'] ? $this->product->index($params) : view('admin.product.product');
    }

    public function show($id)
    {
        if ($id && !empty($detail = $this->product->show($id))) {
            return Response::success($detail);
        }
        return Response::error(['code' => 507]);
    }

    public function form($id = '')
    {
        return view('admin.product.product_form', $id ? ['id' => $id] : []);
    }


    public function store()
    {
        $fillables = [
            'name',
            'price',
            'is_off',
            'off_price',
            'storage',
            'keyword',
            'sort_id',
            'index_image',
            'status',
            'images',
            'hot',
            'is_promote',
            'desc'
        ];
        $params = request()->only($fillables);
        $res = $this->product->create($params);
        return Response::auto($res);
    }

    public function update($id)
    {
        $fillables = [
            'name',
            'price',
            'is_off',
            'off_price',
            'storage',
            'keyword',
            'sort_id',
            'index_image',
            'status',
            'images',
            'hot',
            'is_promote',
            'desc',
        ];
        $params = request()->only($fillables);
        $res = $this->product->update($id, $params);
        return Response::auto($res);
    }

    public function edit($id)
    {
        $res = $this->product->edit($id, request()->get('status'));
        return Response::auto($res);
    }

    public function destroy($id)
    {
        if (!$id) {
            return Response::auto(['code' => 304]);
        }
        $res = $this->product->destroy($id);
        return Response::auto($res);
    }

    public function setting()
    {
        return request()->get('is_ajax') ? '' : view('admin.product.product_setting');
    }

    public function getSort($fid)
    {
        return $this->product->getSort($fid);
    }

    public function updateSort($id)
    {
        return $this->product->updateSort($id, request()->only(['name', 'index_image']));
    }

    public function addSort()
    {
        return Response::auto($this->product->addSort(request()->only(['fid', 'name'])));
    }

    public function deleteSort($id)
    {
        return Response::auto($this->product->deleteSort($id));
    }

    public function getSortTree($id)
    {
        return Response::auto($this->product->getSortTree($id));
    }
}
