<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Resps\Interfaces\Product as ProductInterface;

class ProductApiController extends Controller
{
    protected $product;

    public function __construct(ProductInterface $product)
    {
        $this->product = $product;
    }

    public function index()
    {
        $fillables = [
            'page',
            'per_page_num',
            'order',
            'order_by',
            'name',
            'price',
            'hot',
            'is_promote',
            'sort_id'
        ];
        $params = request()->only($fillables);
        return $this->product->plist($params);
    }

    public function getSort()
    {
        $return = $this->product->getSort(0, 1);
        return array_column($return, 'name', 'id');
    }

    public function getTitleContent()
    {
        $html = '';
        $sorts = array_column($this->product->getSort(0, 1), 'name', 'id');
        foreach ($sorts as $k => $v) {
            $html .= "<li style='border-top:none'><div class='cate-tag'><strong class='NavIcon1'><a href='list.html?sort_id={$k}'>{$v}</a></strong></div></li>";
        }
        return $html;
    }

    public function getLeftSortContent()
    {
        $html = '';
        $sorts = array_column($this->product->getSort(0, 1), 'name', 'id');
        foreach ($sorts as $k => $v) {
            $html .= "<li><a href='list.html?sort_id={$k}'><em>></em>{$v}</a></li>";
        }
        return $html;
    }

    public function getContent()
    {
        $domain = env('ESC_DOMAIN');
        $html1 = $html4 = '';
        $sorts = $this->product->getSort(0, 1);
        $return = array_column($sorts, 'name', 'id');
        $_return = array_column($sorts, 'index_image', 'id');
        $n = 1;
        foreach ($return as $k => $v) {
            $html4 .= "<li><a href='#item{$n}' num='{$n}F'>F{$n}</a></li>";
            $res = $this->product->plist(['sort_id' => $k, 'per_page_num' => 8]);
            $html2 = '';
            if ($res['total']) {
                foreach ($res['list'] as $key => $vo) {
                    $html2 .= <<<EOL
<div class="FloorerSmallBox">
    <div class="FloorerSmallBoxImg">
        <a href="detail.html?id={$vo['pid']}" target="_blank" class="preview2" title="{$vo['name']}">
            <img src="{$domain}{$vo['index_image']}"/>
        </a>
    </div>
    <div class="FloorerSmallBoxH1"
        <a href="detail.html?id={$vo['pid']}" target="_blank">{$vo['name']}</a>
    </div>
    <div class="FloorerSmallBoxH2"> ￥{$vo['off_price']}元<s style="color:#000000">￥{$vo['price']}元</s></div>
</div>
EOL;
                }
            }
            $html3 = <<<EOL
<div class="Floorer" id="item{$n}">
    <div class="MarginCenter">
        <div class="FloorerTitle">
            <div class="FloorerH1">F{$n}<font>{$v}</font></div>
            <span class="FloorerMore"><a href="list.html?sort_id={$k}">更多+</a></span>
        </div>
        <div class="floorerJs">
            <div class="bd">
                <ul class="picList">
                    <li>
                        <div class="FloorerBigBoxImg FloatRight">
                            <a href="list.html?sort_id={$k}"><img src="{$domain}{$_return[$k]}"/></a>
                        </div> 
                    </li>
                </ul>
            </div>
            <div class="hd">
                <ul></ul>
            </div>
        </div>
        <div class="FloorerBigBox FloatLeft">{$html2}</div>
    </div>
</div>
EOL;
            $html1 .= $html3;
            $n++;
        }
        return [$html1, $html4, $this->getTitleContent()];
    }

    public function getHotProducts()
    {
        $html = '';
        $domain = env('ESC_DOMAIN');
        $res = $this->product->plist(['per_page_num' => 8]);
        if ($res['total']) {
            foreach ($res['list'] as $vo) {
                $price = $vo['is_off'] ? $vo['off_price'] : $vo['price'];
                $html .= <<<EOL
                <li>
                    <div class="pic_pnee">
                        <a href="detail.html?id={$vo['pid']}" target="_blank"  style="display: block;">
                            <img src="{$domain}{$vo['index_image']}" width="168" height="168"/>
                        </a>
                        <a href="detail.html?id={$vo['pid']}" target="_blank">{$vo['name']}</a>
                        <div class="jiage_ui">{$price}</div>
                    </div>
                </li>
EOL;
            }
        }
        return $html;
    }

    public function getGuess()
    {
        $html = '';
        $domain = env('ESC_DOMAIN');
        $res = $this->product->plist(['page' => request()->get('page') ?: 1, 'per_page_num' => 5]);
        if ($res['total']) {
            foreach ($res['list'] as $vo) {
                $html .= <<<EOL
            <div class="CnXhSBox">
                <a href="detail.html?id={$vo['pid']}" target="_blank" class="preview2"
                style="width: 201px;height: 144px;text-align: center;display: block;">
                    <img src="{$domain}{$vo['index_image']}"/>
                </a>
                <span class="CnXhSPanText">
                    <a href="detail.html?id={$vo['pid']}" target="_blank">{$vo['sort_name']} {$vo['name']}</a>
                </span>
            </div>
EOL;
            }
        }
        return $html;
    }

    public function getSearch()
    {
        $html = '';
        $domain = env('ESC_DOMAIN');
        $fillable = [
            'page',
            'per_page_num',
            'order',
            'order_by',
            'name',
            'price',
            'hot',
            'is_promote',
            'sort_id'
        ];
        $res = $this->product->plist(request()->only($fillable));
        if ($res['total']) {
            foreach ($res['list'] as $vo) {
                $html .= <<<EOL
                <div class="EquipBox">
                    <div class="proimg" style="    height: 196px; width: 218px;text-align: center;vertical-align: middle; line-height: 196px;display: block;">
                        <a href="detail.html?id={$vo['pid']}" target="_blank" class="preview2">
                            <img src="{$domain}{$vo['index_image']}">
                        </a>
                    </div>
                    <div class="textBar">
                        <h4><a>￥ {$vo['off_price']} 元 <span>￥ {$vo['price']} 元</span></a></h4>
                        <p>{$vo['name']}</p>
                    </div>
                </div>
EOL;
            }
        }
        return [$this->getTitleContent(), $this->getHotProducts(), $html, ['total' => $res['total'], 'current_page' => $res['current_page'], 'last_page' => $res['last_page']], $this->getLeftSortContent()];
    }

    public function getDetail($pid)
    {
        $detail = $this->product->getDetailByPid($pid);
        return [$this->getTitleContent(), $detail, $this->getHotProducts()];
    }
}
