<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/
//用户相关
Route::get('/', function () {
    return redirect('index.html');
});
Route::get('/login', function () {
    return Auth::check() ? redirect('/admin') : view('admin.login');
});
Route::post('/login', 'Admin\AdministratorController@login');
Route::get('/logout', 'Admin\AdministratorController@logout');
Route::get('/api/list', 'Api\NewsApiController@index');
Route::get('/api/detail/{id}', 'Api\NewsApiController@show');
Route::group(['middleware' => 'auth'], function ($route) {
    $route->get('/admin', function () {
        return redirect('/news/news');
    });
    //文档
    $route->get('/news/form/{id?}', 'Admin\NewsController@form');
    $route->resource('/news/news', 'Admin\NewsController');
    $route->get('/news/change_status/{id}', 'Admin\NewsController@changeStatus');
    //文档设置
    $route->get('/news/setting', 'Admin\NewsController@setting');
    //文档分类设置
    $route->get('/news/sort/{fid}', 'Admin\NewsController@getSort');
    $route->post('/news/sort', 'Admin\NewsController@addSort');
    $route->put('/news/sort/{id}', 'Admin\NewsController@updateSort');
    $route->delete('/news/sort/{id}', 'Admin\NewsController@deleteSort');
    $route->get('/news/get_sort_tree/{id}', 'Admin\NewsController@getSortTree');

    //商品
    $route->get('/product/form/{id?}', 'Admin\ProductController@form');
    $route->resource('/product/product', 'Admin\ProductController');
    $route->post('/product/edit/{id}', 'Admin\ProductController@edit');
    //商品设置
    $route->get('/product/setting', 'Admin\ProductController@setting');
    //商品分类设置
    $route->get('/product/sort/{fid}', 'Admin\ProductController@getSort');
    $route->post('/product/sort', 'Admin\ProductController@addSort');
    $route->put('/product/sort/{id}', 'Admin\ProductController@updateSort');
    $route->delete('/product/sort/{id}', 'Admin\ProductController@deleteSort');
    $route->get('/product/get_sort_tree/{id}', 'Admin\ProductController@getSortTree');

    //base64图片上传
    $route->post('/upload/base64', 'Admin\UploadController@index');
});
Route::group(['prefix' => 'api'], function ($route) {
    $route->get('/news', 'Api\NewsApiController@index');
    $route->get('/news_detail/{id}', 'Api\NewsApiController@show');
    $route->get('/getsort', 'Api\ProductApiController@getSort');
    $route->get('/get_content', 'Api\ProductApiController@getContent');
    $route->get('/get_detail/{pid}', 'Api\ProductApiController@getDetail');
    $route->get('/get_guess/', 'Api\ProductApiController@getGuess');
    $route->get('/get_search/', 'Api\ProductApiController@getSearch');
    $route->get('/get_title_content/', 'Api\ProductApiController@getTitleContent');
    $route->get('/product', 'Api\ProductApiController@index');
});
