<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Response;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Response::macro('error', function ($data) {
            return (is_array($data)
                && isset($data['code'])
                && $data['code']
                && config("error.{$data['code']}"))
                ? [
                    'code' => $data['code'],
                    'msg' => config("error.{$data['code']}")
                ]
                : ['code' => 9000, 'msg' => 'Unknow Error'];
        });
        Response::macro('success', function ($data) {
            return ['code' => 0, 'data' => $data];
        });
        Response::macro('auto', function ($data) {
            if (!is_array($data) || !isset($data['code'])) {
                return ['code' => 9000, 'msg' => '结果参数错误'];
            }
            if (!$data['code']) {
                return array_merge(['code' => 0], $data);
            }
            if (!config("error.{$data['code']}")) {
                return ['code' => 9001, 'msg' => '未知错误'];
            }
            return [
                'code' => $data['code'],
                'msg' => config("error.{$data['code']}")
            ];
        });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        app()->bind('App\Resps\Interfaces\Administrator', 'App\Resps\Eloquents\Administrator');
        app()->bind('App\Resps\Interfaces\News', 'App\Resps\Eloquents\News');
        app()->bind('App\Resps\Interfaces\Image', 'App\Resps\Eloquents\Image');
        app()->bind('App\Resps\Interfaces\Upload', 'App\Resps\Eloquents\Upload');
        app()->bind('App\Resps\Interfaces\Product', 'App\Resps\Eloquents\Product');
    }
}
