<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNewsSortsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('news_sorts', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            $table->integer('fid');
            $table->tinyInteger('level');
            $table->string('name', 15);
            $table->integer('creator_id');
            $table->integer('mender_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('news_sorts');
    }
}
