<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            $table->string('pid', 32)->unique();
            $table->string('name', 50)->comment('名称');
            $table->decimal('price', 10, 2)->comment('价格');
            $table->tinyInteger('is_off')->defalut(0)->comment('是否打折0-1');
            $table->decimal('off_price', 10, 2)->comment('折后价格');
            $table->smallInteger('storage')->default(0);
            $table->string('keyword', 100)->nullable();
            $table->integer('sort_id');
            $table->string('index_image', 255)->nullable()->comment('索引图');
            $table->tinyInteger('status')->default(0)->comment('0:新建,1:待发布,2:已发布,3:已撤回');
            $table->text('images')->nullable()->comment('展示图');
            $table->tinyInteger('hot')->defalut(0)->comment('热度0-100');
            $table->tinyInteger('is_promote')->defalut(0)->comment('推荐0-1');
            $table->text('desc')->nullable()->comment('描述');
            $table->integer('creator_id');
            $table->integer('mender_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('products');
    }
}
