<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductsSortsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products_sorts', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            $table->integer('fid');
            $table->tinyInteger('level');
            $table->string('name', 15);
            $table->string('index_image', 255)->nullable();
            $table->integer('creator_id');
            $table->integer('mender_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('products_sorts');
    }
}
