<?php

use Illuminate\Database\Seeder;
use App\Models\News;
use App\Models\NewsSorts;

class NewsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        News::truncate();
        NewsSorts::truncate();
        News::create([
            'title' => '野生粽子',
            'keyword' => '野生,粽子',
            'abstract' => '九华山地区首次发现野生粽子',
            'sort_id' => 1,
            'index_image' => '/static/img/default/news_index.jpg',
            'content' => '<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <span class="text-big"><strong>大粽子</strong></span>是一句在盗墓者中流传的暗语，就象山里的土匪之间谈话也不能直接说自己杀人放火，都有一套黑话切口。<br>&nbsp; &nbsp; &nbsp; 粽子是指墓里保存的比较完好，没有腐烂的尸体，摸到大粽子就是碰上麻烦了，指僵尸、恶鬼之类不干净的东西。&nbsp;<br>　粽子：会动的有害尸体。<br>&nbsp;　1. <mark class="marker-green">大粽子</mark>：厉害的僵尸、恶鬼之类的东西。<br>&nbsp;　2.<mark class="marker-yellow">老粽子</mark>：可发生尸变的不好对付的僵尸。<br>&nbsp;　3.<mark class="marker-blue">干粽子</mark>：是指墓里的尸体烂得只剩下一堆白骨了。&nbsp;<br>　 4.<mark class="pen-red">肉粽子</mark>：是指尸体身上值钱的东西多。<br>&nbsp;　5.<mark class="pen-green">血粽子</mark>：血尸墓中的粽子，最厉害。</p>',
            'creator_id' => 1,
            'mender_id' => 1
        ]);
        NewsSorts::create(
            [
                'fid' => 0,
                'level' => 1,
                'name' => '官网资讯',
                'creator_id' => 1,
                'mender_id' => 1
            ]
        );
        NewsSorts::create(
            [
                'fid' => 0,
                'level' => 1,
                'name' => '月饼网站资讯',
                'creator_id' => 1,
                'mender_id' => 1
            ]
        );
        NewsSorts::create(
            [
                'fid' => 2,
                'level' => 2,
                'name' => '公司简介',
                'creator_id' => 1,
                'mender_id' => 1
            ]
        );
        NewsSorts::create(
            [
                'fid' => 2,
                'level' => 2,
                'name' => '网站公告',
                'creator_id' => 1,
                'mender_id' => 1
            ]
        );
        NewsSorts::create(
            [
                'fid' => 2,
                'level' => 2,
                'name' => '月饼资讯',
                'creator_id' => 1,
                'mender_id' => 1
            ]
        );
        NewsSorts::create(
            [
                'fid' => 2,
                'level' => 2,
                'name' => '商城动态',
                'creator_id' => 1,
                'mender_id' => 1
            ]
        );
    }
}
