<?php

use Illuminate\Database\Seeder;
use App\Models\Product;
use App\Models\ProductsSorts;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Product::truncate();
        ProductsSorts::truncate();
        $images = [
            [
                "id" => 1,
                "name" => "image_1",
                "path" => "/static/img/default/image_1.jpeg",
                "desc" => "玫瑰女王",
                "order_id" => "1"
            ],
            [
                "id" => 2,
                "name" => "image_2",
                "path" => "/static/img/default/image_2.png",
                "desc" => "远景",
                "order_id" => "2"
            ],
            [
                "id" => 3,
                "name" => "image_3",
                "path" => "/static/img/default/image_3.png",
                "desc" => "红樱",
                "order_id" => "3"
            ],
            [
                "id" => 4,
                "name" => "image_4",
                "path" => "/static/img/default/image_4.jpeg",
                "desc" => "Diablo",
                "order_id" => "4"
            ]
        ];
        Product::create([
            'pid' => strtoupper(md5(sha1(microtime(1)))),
            'name' => '测试商品',
            'price' => 12.01,
            'is_off' => 1,
            'off_price' => 12.00,
            'storage' => 999,
            'keyword' => '测试',
            'sort_id' => 1,
            'index_image' => '/static/img/default/image_1.jpeg',
            'status' => 0,
            'images' => serialize($images),
            'hot' => 20,
            'is_promote' => 1,
            'desc' => '测试商品',
            'creator_id' => 1,
            'mender_id' => 1,
        ]);
        ProductsSorts::create(
            [
                'fid' => 0,
                'level' => 1,
                'name' => '全国月饼券',
                'index_image' => '',
                'creator_id' => 1,
                'mender_id' => 1
            ]
        );
    }
}
