new (class newsApp extends AdminBase {
    constructor() {
        super();
        this.init();
    }

    init() {
        const newsApp = new Vue({
            el: "#news-table",
            data: {
                total: 0,
                list: {}
            },
            created: function () {
                this.get_list();
            },
            methods: {
                get_list: function (page = 1, title = '') {
                    let that = this;
                    title = encodeURIComponent(title);
                    $.getJSON(`/news/news?title=${title}&page=${page}&is_ajax=1`, function (data) {
                        that.total = data.total;
                        that.list = data.list;
                        AdminBase.pagination($('#page-wrap'), {
                            total: data.total,
                            current_page: data.current_page,
                            last_page: data.last_page,
                            callback: that.get_list,
                        });
                    });
                },
                del: (id) => {
                    if (!id) {
                        return AdminBase.fail('错误操作！');
                    }
                    return AdminBase.warn('确认删除此条文档吗?', () => {
                            this.delete(id);
                        }
                    );
                },
                changeStatus: (id, status) => {
                    if (!id) {
                        return AdminBase.fail('错误操作！');
                    }
                    status = status | 0;
                    return AdminBase.warn(status === 1 ? '确认推荐此案例到首页吗?' : '确认取消推荐此案例吗?', () => {
                            this.changeStatus(id, status);
                        }
                    );
                }
            }
        });
        $('.content').off().on('click', '.title-search', () => {
            let val = AdminBase.tools().trim($('.title-input').val());
            return val.length && newsApp.get_list(1, val);
        })
    }

    delete(id) {
        $.ajax({
            url: `/news/news/${id}`,
            type: 'delete',
            headers: {'X-CSRF-TOKEN': AdminBase.csrf_token()},
            success: (data) => {
                return data.code === 0 ? AdminBase.success('删除成功', () => {
                    location.href = '/news/news'
                }, 1000) : AdminBase.fail(data.msg || '删除失败')
            }
        });
    }

    changeStatus(id, status) {
        $.ajax({
            url: `/news/change_status/${id}?status=${status}`,
            type: 'get',
            headers: {'X-CSRF-TOKEN': AdminBase.csrf_token()},
            success: (data) => {
                return data.code === 0 ? AdminBase.success('操作成功', () => {
                    location.href = '/news/news'
                }, 1000) : AdminBase.fail(data.msg || '操作失败')
            }
        });
    }
});