new (class productApp extends AdminBase {
    constructor() {
        super();
        this.init();
    }

    init() {
        const productApp = new Vue({
            el: "#product-table",
            data: {
                total: 0,
                statusShow: {
                    0: '<span class="grey">未发布</span>',
                    1: '<span class="green">已发布</span>',
                },
                list: {}
            },
            created: function () {
                this.get_list();
            },
            methods: {
                get_list: function (page = 1, name = '') {
                    let that = this;
                    name = encodeURIComponent(name);
                    $.getJSON(`/product/product?name=${name}&page=${page}&is_ajax=1`, function (data) {
                        that.total = data.total;
                        that.list = data.list;
                        AdminBase.pagination($('#page-wrap'), {
                            total: data.total,
                            current_page: data.current_page,
                            last_page: data.last_page,
                            callback: that.get_list,
                        });
                    });
                },
                del: (id) => {
                    if (!id) {
                        return AdminBase.fail('错误操作！');
                    }
                    return AdminBase.warn('确认删除此商品吗?', () => {
                            this.delete(id);
                        }
                    );
                },
                publish(id, model = true) {
                    let desc = model ? '发布' : '撤回';
                    return AdminBase.warn(`确认${desc}此商品吗?`, () => {
                            $.ajax({
                                url: `/product/edit/${id}`,
                                method: 'post',
                                data: {id: id, status: model | 0},
                                headers: {'X-CSRF-TOKEN': AdminBase.csrf_token()},
                                success: (data) => {
                                    return data.code === 0 ? AdminBase.success(`${desc}成功`, () => {
                                        location.reload();
                                    }, 1000) : AdminBase.fail(data.msg || `${desc}失败`);
                                }
                            });
                        }
                    );
                }
            }
        });
        $('.content').off().on('click', '.title-search', () => {
            let val = AdminBase.tools().trim($('.title-input').val());
            return val.length && productApp.get_list(1, val);
        })
    }

    delete(id) {
        $.ajax({
            url: `/product/product/${id}`,
            type: 'delete',
            headers: {'X-CSRF-TOKEN': AdminBase.csrf_token()},
            success: (data) => {
                return data.code === 0 ? AdminBase.success('删除成功', () => {
                    location.href = '/product/product'
                }, 1000) : AdminBase.fail(data.msg || '删除失败')
            }
        });
    }
});