new (class productFormApp extends AdminBase {
    constructor() {
        super();
        this.id = id;
        this.init();
    }

    init() {
        // 索引图上传
        let _this = this;
        new Vue({
            el: '#product_form_app',
            data: {
                sort_span: {
                    html: '',
                    show: false
                },
                form_data: {
                    name: '',
                    price: '',
                    is_off: 0,
                    off_price: '',
                    storage: '',
                    sort_id: 0,
                    index_image: '',
                    images: [],
                    hot: '',
                    is_promote: 0,
                    desc: ''
                },
                max_order: 0,
            },
            mounted: function () {
                DecoupledEditor
                    .create(document.querySelector('#editor-container'), {
                        language: 'zh-cn'
                    })
                    .then(editor => {
                        const toolbarContainer = document.querySelector('#toolbar-container');
                        toolbarContainer.appendChild(editor.ui.view.toolbar.element);
                        editor.plugins.get('FileRepository').createUploadAdapter = function (loader) {
                            return new CkuploadAdapter(loader);
                        };
                        _this.editor = editor;
                    })
                    .catch(error => {
                        console.error(error);
                    });
                //更新操作
                if (_this.id) {
                    $.getJSON(`/product/product/${_this.id}`, (data) => {
                        if (data.code !== 0 || !data.data) {
                            return AdminBase.danger(data.msg || '操作异常', () => {
                                location.href = '/product/product'
                            }, 1000);
                        }
                        let detail = data.data;
                        this.form_data.name = detail.name;
                        this.form_data.sort_id = detail.sort_id;
                        if (detail.sort_id > 0) {
                            this.sort_span.html = detail.sorttree.names.join(' > ');
                            this.sort_span.show = true;
                        }
                        this.form_data.images = detail.images;
                        this.form_data.index_image = detail.index_image;
                        this.form_data.desc = detail.desc;
                        this.form_data.price = detail.price;
                        this.form_data.is_off = detail.is_off;
                        this.form_data.off_price = detail.off_price;
                        this.form_data.storage = detail.storage;
                        this.form_data.hot = detail.hot;
                        this.form_data.is_promote = detail.is_promote;
                        _this.editor.setData(detail.desc);
                    });
                }
            },
            methods: {
                dealCheckboxChange: function (type, e) {
                    ['is_promote', 'is_off'].includes(type) && (this.form_data[type] = e.currentTarget.checked | 0);
                },
                afterSelect: function (id) {
                    (new Promise((resolved, reject) => {
                        $.getJSON(`/product/get_sort_tree/${id}`, (data) => {
                            data.code === 0 && resolved(data);
                            data.code !== 0 && reject(data);
                        });
                    })).then((data) => {
                        this.sort_span.html = data.data.names.join(' > ');
                        this.sort_span.show = true;
                        this.form_data.sort_id = id;
                    }).catch((data) => {
                        return AdminBase.fail(data.msg || '获取分类树失败');
                    });
                },
                rmSelect: function (id) {
                    let _this = this;
                    this.form_data.images.forEach(function (x, y) {
                        x.id === id && _this.form_data.images.splice(y, 1)
                    });
                },
                triggerFile: function () {
                    document.querySelector('input[name=index_image]').click();
                },
                handleImage: function (event) {
                    let input = event.currentTarget,
                        file = input.files[0],
                        _this = this;
                    new Promise((resolve, reject) => {
                        new Upload(file, resolve, reject);
                    }).then(function (a) {
                        _this.form_data.images.push({
                            id: a.data.id,
                            name: a.data.name,
                            path: a.default,
                            desc: a.data.desc,
                            order_id: ++_this.max_order,
                        });
                    }).catch(
                        //todo upload failed suggestion
                    );
                },
                setCover: function (path) {
                    this.form_data.index_image = path;
                },
                formSub: function () {
                    let type = `${_this.id ? 'PUT' : 'POST'}`,
                        prefix = _this.id ? '修改' : '创建';
                    if (!this.form_data.index_image) {
                        if (this.form_data.images.length === 0) {
                            return AdminBase.warn('请添加商品封面图');
                        }
                        this.form_data.index_image = this.form_data.images[0].path;
                    }
                    this.form_data.desc = _this.editor.getData();
                    $.ajax({
                        url: `/product/product${_this.id ? '/' + _this.id : ''}`,
                        type: type,
                        data: this.form_data,
                        headers: {'X-CSRF-TOKEN': AdminBase.csrf_token()},
                        success: (data) => {
                            return data.code === 0 ? AdminBase.success(`${prefix}成功`, () => {
                                location.href = '/product/product'
                            }, 1000) : AdminBase.fail(data.msg || `${prefix}失败`);
                        }
                    });
                }
            }
        });

    }
});