new (class productSetting extends AdminBase {
    constructor() {
        super();
        this.init();
    }

    init() {
        new Vue({
            el: '#sort_tab'
        });
        new Vue({
            el: '#sort_tab2',
            data: {
                sorts: {},
            },
            mounted() {
                let _this = this;
                $.getJSON('/product/sort/0', function (data) {
                    for (let i in data) {
                        let path = data[i].index_image;
                        data[i].index_image = path ? {
                            is_upload: true,
                            title: '点击修改',
                            html: `<div class="index_image_wrap"><i class="fa fa-times-circle" title="删除"></i><img src="${path}"></div>`,
                            style: {lineHeight: 'normal'},
                        } : {
                            is_upload: false,
                            title: '点击添加',
                            html: '<i class="fa fa-plus"></i>',
                            style: {lineHeight: '6rem'},
                        }
                        data[i].path = path ? path : '';
                    }
                    _this.sorts = data;
                });
            },
            methods: {
                triggerFile: function (key, event) {
                    let file = document.querySelector('#index_image' + key);
                    if (!this.sorts[key].index_image.is_upload) {
                        file.click();
                    }
                    if (this.sorts[key].index_image.is_upload && event.target.tagName === 'I') {
                        //todo 选择上次图片bug，删除服务器图片
                        this.sorts[key].index_image.title = '点击添加';
                        this.sorts[key].index_image.html = '<i class="fa fa-plus"></i>';
                        this.sorts[key].index_image.style = {lineHeight: '6rem'};
                        this.sorts[key].path = '';
                        this.sorts[key].index_image.is_upload = false;
                        this.updateSort(key);
                    }
                },
                handleImage: function (key, event) {
                    let input = event.currentTarget,
                        file = input.files[0],
                        _this = this;
                    new Promise((resolve, reject) => {
                        new Upload(file, resolve, reject);
                    }).then(function (a) {
                        _this.sorts[key].index_image.is_upload = true;
                        _this.sorts[key].path = a.default;
                        _this.sorts[key].index_image.title = '点击修改';
                        _this.sorts[key].index_image.html = `<div class="index_image_wrap"><i class="fa fa-times-circle" title="删除"></i><img src="${a.default}"></div>`;
                        _this.sorts[key].index_image.style = {lineHeight: 'normal'};
                        _this.updateSort(key);
                    }).catch(
                        //todo upload failed suggestion
                    );
                },
                updateSort(key) {
                    let data = this.sorts[key];
                    $.ajax({
                        url: `/product/sort/${data.id}`,
                        method: 'put',
                        data: {name: data.name, index_image: data.path},
                        headers: {'X-CSRF-TOKEN': AdminBase.csrf_token()},
                        success: (data) => {
                            return data.code !== 0 ? AdminBase.fail(data.msg || `保分类图保存失败`) : false;
                        }
                    });
                }
            }
        });
    }
});