<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>捌零玖零多媒体运营平台</title>
    @section('head')
        <link rel="stylesheet" href="/static/plugins/font-awesome/css/font-awesome.min.css">
        <link rel="stylesheet" href="/static/css/common/adminlte.css">
        <link rel="stylesheet" href="/static/css/common/animate.css">
        <link rel="stylesheet" href="/static/css/common/base.css?vt={{time()}}">
        <link rel="stylesheet" href="/static/css/index/index.css?vt={{time()}}">
        <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    @show
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
    <!-- 导航栏 -->
    <nav class="main-header navbar navbar-expand bg-white navbar-light border-bottom">
        <!-- 左侧 -->
        <ul class="navbar-nav">
            <li class="nav-item">
                <a class="nav-link" data-widget="pushmenu" href="#"><i class="fa fa-bars"></i></a>
            </li>
        </ul>
        <!-- 右侧 -->
        <ul class="navbar-nav ml-auto">
            <li class="nav-item">
                <div class="user-panel d-flex">
                    <div class="image">
                        <img src="{{Auth()->user()->avatar}}" class="img-circle" alt="User Image">
                    </div>
                    <div class="info">
                        <a href="#" class="d-block orange">{{Auth()->user()->username}}</a>
                    </div>
                </div>
            </li>
            <li class="nav-item" style="margin:0.4rem 0 0 0.4rem">
                <a href="/logout" title="退出登录"><span class="fa fa-sign-out" style="color:dimgrey;"></span></a>
            </li>
        </ul>
    </nav>
    <!-- 导航栏结束 -->
    <!-- 侧边栏 -->
    <aside class="main-sidebar sidebar-dark-primary elevation-4">
        <!-- Logo -->
        <a href="/admin" class="brand-link">
            <img src="/static/img/AdminLTELogo.png" alt="Logo" class="brand-image img-circle elevation-3"
                 style="opacity: .8">
            <span class="brand-text font-weight-light">BLJLMWS</span>
        </a>
        <div class="sidebar">
            <nav class="mt-2">
                <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                    data-accordion="false">
                    <li class="nav-item">
                        <a href="/news/news" class="nav-link">
                            <i class="nav-icon fa fa-newspaper-o"></i>
                            <p>资讯</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="/product/product" class="nav-link">
                            <i class="nav-icon fa fa-shopping-cart"></i>
                            <p>商品</p>
                        </a>
                    </li>
                </ul>
            </nav>
        </div>
    </aside>
    <!-- 侧边栏结束 -->
    <!-- 内容主体 -->
    <div class="content-wrapper  pt10">
        @yield('main-content')
    </div>
    <!-- 内容主体结束 -->
    <!-- 快捷操作栏 -->
    {{--<aside class="control-sidebar control-sidebar-dark"></aside>--}}
    <footer class="main-footer" style="text-align:center;">
        <strong>Copyright &copy; 2014-2018 <a href="/">南京捌零玖零多媒体运营平台</a>.</strong> All rights reserved.
    </footer>
</div>
@section('script')
    <script src="/static/plugins/jquery/jquery.min.js"></script>
    <script src="/static/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="/static/js/adminlte.js"></script>
    <script src="/static/plugins/vue/vue.js"></script>
    <script src="/static/plugins/axios/axios.js"></script>
    <script src="/static/js/adminbase.js?vt={{time()}}"></script>
@show
</body>
</html>
