@extends('admin.index')
@section('head')
    @parent
@endsection
@section('main-content')
    <section class="content animated slideInRight">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <a class="btn btn-primary btn-sm fa fa-plus-square-o white" href="/news/form"> 新建文档 </a>
                        <a class="btn btn-info btn-sm fa fa-gear white" href="/news/setting"> 设置 </a>
                        <div class="card-tools" style="top:0.7rem">
                            <div class="input-group input-group-sm">
                                <input type="text" class="form-control title-input" placeholder="标题搜索">
                                <div class="input-group-append">
                                    <div class="btn btn-default">
                                        <i class="fa fa-search title-search"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover admin-table" id="news-table">
                                <thead>
                                <tr>
                                    <th width="6%">选择</th>
                                    <th width="20%">标题</th>
                                    <th width="10%">分类</th>
                                    <th width="10%">状态</th>
                                    <th width="15%">记录</th>
                                    <th width="19%">操作</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr v-if="total == 0">
                                    <td colspan="6">暂无相关记录</td>
                                </tr>
                                <tr v-if="total > 0 " v-for="item in list">
                                    <td><input type="checkbox"></td>
                                    <td>
                                        <a :href="`/news/form/${item.id}`">
                                            <img :src="item.index_image" class="index_image" v-if="item.index_image">
                                            <span class="title_span cp grey" :title="item.title">@{{item['title']}}</span>
                                        </a>
                                    </td>
                                    <td>@{{item.sort_name}}</td>
                                    <td>新建</td>
                                    <td>
                                        <span>@{{item.creator_name}} @{{item.created_at}}</span>
                                        <span>@{{item.mender_name}} @{{item.updated_at}}</span>
                                    </td>
                                    <td>
                                        <template v-if="item.sort_id !== 3">
                                            <i class="fa fa-star-o grey" title="推荐首页" v-if="item.status === 0" @click="changeStatus(item.id,1)"></i>
                                            <i class="fa fa-star orange" title="取消推荐" v-if="item.status === 1" @click="changeStatus(item.id,0)"></i>
                                        </template>
                                        <template v-if="item.sort_id === 3">
                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        </template>
                                        <i class="fa fa-trash-o" title="删除" @click="del(item.id)"></i>&nbsp;
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div id="page-wrap"></div>
                    </div>
                </div>
            </div>
        </div>
        </div>
    </section>
@section('script')
    @parent
    <script src="/static/js/news/news.js?vt={{time()}}"></script>
@endsection
@endsection