@extends('admin.index')
@section('head')
    @parent
    <link href="/static/css/product/product_form.css?vt={{time()}}" type="text/css" rel="stylesheet">
@endsection
@section('main-content')
    <section class="content animated slideInRight">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-12">
                        <ol class="breadcrumb float-sm-left">
                            <li class="breadcrumb-item"><a href="/product/product">商品</a></li>
                            <li class="breadcrumb-item active">{{isset($id) ? '修改商品' : '新建商品'}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <form id="product_form_app">
                        <ul class="timeline timeline-inverse" id="product_form_ul">
                            <li class="time-label">
                                <span>名称</span>
                            </li>
                            <li>
                                <div class="timeline-item">
                                    <input type="text" class="form-control" v-model="form_data.name">
                                    <span class="form_check_span red">* 必填</span>
                                    <span class="form_check_span grey">* 50字符限制</span>
                                </div>
                            </li>
                            <li class="time-label">
                                <span>属性</span>
                            </li>
                            <li>
                                <div class="timeline-item">
                                    <table class="product-list-table">
                                        <tr>
                                            <td>单价</td>
                                            <td><input type="text" placeholder="0" v-model="form_data.price"></td>
                                            <td>打折</td>
                                            {{--<td><span><input type="checkbox" id="r_2" class="chk"  @change="dealCheckboxChange('is_off',$event)" :checked="form_data.is_off === 1"> <label for="r_2"></label></span></td>--}}
                                            <td><span><input type="checkbox" id="r_2" class="chk"  checked> <label for="r_2"></label></span></td>
                                            <td>折后价</td>
                                            <td><input type="text" placeholder="0" v-model="form_data.off_price"></td>
                                        </tr>
                                        <tr>
                                            <td>库存</td>
                                            <td><input type="text" placeholder="0" v-model="form_data.storage"></td>
                                            <td>热度</td>
                                            <td><input type="text" placeholder="0" v-model="form_data.hot"></td>
                                            <td>推荐</td>
                                            <td><span><input type="checkbox" id="r_3" class="chk" @change="dealCheckboxChange('is_promote',$event)" :checked="form_data.is_promote === 1"> <label for="r_3"></label></span></td>
                                        </tr>
                                    </table>
                                    <span class="form_check_span red">* 单价为必填</span>
                                </div>
                            </li>
                            <li class="time-label">
                                <span>分类</span>
                                <span class="sort_select_span" @click="rmSelect($event)"
                                      v-show="sort_span.show">@{{sort_span.html}} <i
                                            class="fa fa-times-circle"></i></span>
                            </li>
                            <li>
                                <div class="timeline-item">
                                    <div class="timeline-body">
                                        <sort-component url="/product/sort" editable="false"></sort-component>
                                    </div>
                                </div>
                            </li>
                            <li class="time-label">
                                <span>展示图</span>
                            </li>
                            <li>
                                <div class="timeline-item">
                                    <div class="timeline-body">
                                        <div class="images_deal_wrap">
                                            <span class="product_upload_span" title="添加图片" @click="triggerFile"><i
                                                        class="fa fa-plus"></i></span>
                                            <input type="file" name="index_image" style="display:none"
                                                   @change="handleImage($event)">
                                            <span class="image_wrap animated slideInLeft"
                                                  v-for="image in form_data.images">
                                                <img :src="image.path">
                                                <i class="fa fa-times-circle img-delete-i" title="删除"
                                                   @click="rmSelect(image.id,$event)"></i>
                                                <i class="fa  fa-bookmark-o img-cover-i" title="设为封面"
                                                   @click="setCover(image.path,$event)"
                                                   v-show="image.path !== form_data.index_image"></i>
                                                <img class="cover_logo" src="/static/img/default/gallery_cover.png"
                                                     v-show="image.path === form_data.index_image">
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li class="time-label">
                                <span>描述</span>
                            </li>
                            <li>
                                <div class="timeline-item bw1">
                                    <div id="toolbar-container"></div>
                                    <div id="editor-container"></div>
                                </div>
                            </li>
                            <li class="time-label">
                                <span class="product_sub cp" @click="formSub">保存</span>
                            </li>
                        </ul>
                    </form>
                </div>
            </div>
        </div>
    </section>
@section('script')
    @parent
    <script>
        let id = '{{isset($id) ? $id : null}}';
    </script>
    <script src="/static/js/ckeditor/ckeditor.js"></script>
    <script src="/static/js/ckeditor/translations/zh-cn.js"></script>
    <script src="/static/js/upload.js?vt={{time()}}"></script>
    <script src="/static/js/ckuploadAdapter.js?vt={{time()}}"></script>
    <script src="/static/js/common/component.js?vt={{time()}}"></script>
    <script src="/static/js/product/product_form.js?vt={{time()}}"></script>
@endsection
@endsection