@extends('admin.index')
@section('head')
    @parent
    <link href="/static/css/product/product_form.css?vt={{time()}}" type="text/css" rel="stylesheet">
    <style>
        .setting-upload-div .sort-image-span {
            display: block;
            width: 8rem;
            height: 6rem;
            border: 1px solid #ced4da;
            text-align: center;
            color: #ced4da;
            cursor: pointer;
        }

        .sort-image-span > div {
            position: relative;
            width: 100%;
            height: 100%;
        }

        .sort-image-span > div > i {
            position: absolute;
            /*display: none;*/
            top: 0;
            right: 0;
            cursor: pointer;
        }

        .sort-image-span > div > img {
            width: 100%;
            height: 100%;
        }
    </style>
@endsection
@section('main-content')
    <section class="content animated slideInRight">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-12">
                        <ol class="breadcrumb float-sm-left">
                            <li class="breadcrumb-item"><a href="/product/product">商品</a></li>
                            <li class="breadcrumb-item active">设置</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex p-0">
                        <ul class="nav nav-pills  p-2">
                            <li class="nav-item"><a class="nav-link active show" href="#sort_tab"
                                                    data-toggle="tab">分类设置</a></li>
                            <li class="nav-item"><a class="nav-link" href="#sort_tab2" data-toggle="tab">分类图片</a></li>
                        </ul>
                    </div>
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane animated fadeIn active show" id="sort_tab">
                                <sort-component url="/product/sort" editable="true"></sort-component>
                            </div>
                            <div class="tab-pane animated fadeIn" id="sort_tab2">
                                <div class="setting-upload-div">
                                    <div v-for="(item,key) in sorts">
                                        <span>@{{item.name}}</span>
                                        <span class="sort-image-span" :title="item.index_image.title"
                                              @click="triggerFile(key,$event)"
                                              :style="item.index_image.style"
                                              v-html="item.index_image.html">

                                        </span>
                                        <input type="file" :id="'index_image'+key" name="index_image"
                                               style="display:none" @change="handleImage(key,$event)">
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane animated fadeIn" id="tab_3">
                                //todo 审核设置
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@section('script')
    @parent
    <script src="/static/js/common/component.js?vt={{time()}}"></script>
    <script src="/static/js/upload.js?vt={{time()}}"></script>
    <script src="/static/js/product/product_setting.js?vt={{time()}}"></script>
@endsection
@endsection